#ifndef APPL_UTIL_JSON_PARSERS_MPDT_CONFIG_PARSERS_H_
#define APPL_UTIL_JSON_PARSERS_MPDT_CONFIG_PARSERS_H_


#include "fc_mcan_tcu_AppMain.h"
#include "json_utils.h"
#include "fc_mcan_tcu_ClassTypes.h"
//#include "I_MPDT_Config_Parsers.h"
//class Ifc_mcan_tcu_KDSHandler;
//class Ifc_mcan_tcu_P_DP_Handler;

class MPDT_Config_Parsers
{
private:
	std::string sJsonMap_Config_FilePath;
	std::string sJsonMsg_Config_FilePath;
	unsigned short LoadJsonDataFromFile(Json::Value &data,std::string path);

public:
	MPDT_Config_Parsers();
	virtual ~MPDT_Config_Parsers();

	 tBool bGetBrandName(std::string sBrandValue,std::string &sBrandName);
	 tBool bGetVehicleModeType(std::string sVechiletypeValue,std::string &sVechiletypeName);
	 tBool bGetTcuAvailabilityStatus(std::string sTcuStatusValue,std::string &sTcuStatusName);
	 tBool bGetRegion(tU8 u8RegionValue, std::string sOEMName,std::string &sRegionName,std::string sArchitecture);
	 tBool bGetListofAllowedMsgs(tU8 u8Brand,tU8 u8EngineType,tU8 u8TCUAvailability,tU8 u8Region,std::string sArchitecture,std::vector<tU16> &oAllowedMsgsList,std::string &sKeyPrepared);
	 tBool bGetRegionCode(tU8 u8Region,std::string &sRegionCode);
	 tBool bGetMCANTrigger(tU8 u8VCANDiversity,tU8 u8Brand,tU8 &u8TriggerType);
	 tBool bGetITCMaskTrigger(tU8 u8VCANDiversity,tU8 u8Brand,tU8 &u8TriggerType);
	 tBool bGetCOMM_ERR_ITC(tU8 u8VCANDiversity,tU8 u8Brand,tU32 &u32ITC);
	 tBool bGetDDATA_ERR_ITC(tU8 u8VCANDiversity,tU8 u8Brand,tU32 &u32ITC);
	 tBool bGetCDATA_ERR_ITC(tU8 u8VCANDiversity,tU8 u8Brand,tU32 &u32ITC);

private:

	json_utils oParseUtil;
	//std::string MsgconfigFilepath;
	//std::string MapconfigFilepath;
	std::string sU8ToStr(tU8 u8Val);

	 tBool bReadAllMaps(Json::Value &oAllMaps);
	 tBool bReadMapItems(std::string ItemName,Json::Value& oMapItem);
	 tBool bReadlistofMsgItems(Json::Value &oData);
	 /*tBool bReadBrandItem(Json::Value&oAllMsgConfigurations,tU8 u8Brand,Json::Value &tBrand);
	 tBool bReadEngineTypeItem(Json::Value &tBrand,tU8 u8EngineType,Json::Value &tEngineType);
	 tBool bReadTcuStatusItem(Json::Value &tEngineType,tU8 u8TCUAvailability,Json::Value &tRegion);
	 tBool bReadRegion(Json::Value &tRegion,tU8 u8Region,std::vector<tU16> &oAllowedMsgsList);*/
	 tBool bReadlistofAllowedMsgs(Json::Value &oData,std::string sFinalString,std::vector<tU16> &oAllowedMsgsList);
	 tBool bGetVCANDiverityStr(std::string sVCANDivVal, std::string &sVCANDivName);

	 tBool bReadChannelConfig(Json::Value &oChnlConfig);
	 tBool bGetChannelConf(tU8 u8VCANDiversity,tU8 u8Brand,Json::Value &oNode);
	 tBool bGetChannelConfByVCANDiv(tU8 u8VCANDiversity,Json::Value &oAllConf,Json::Value &oNode);
	 tBool bGetChannelConfByOEM(tU8 u8VCANDiversity,Json::Value &oConfByVCANDiv,Json::Value &oNode);
	 tBool bGetChannelConfvalues(Json::Value &oNode,std::string sConfItemName,tU32 &u3Val);
	 tBool bGetRegionNameByOEMArch(Json::Value &oOEMBasedMapArray,const tU8 u8RegionCode,const std::string sOEMName,std::string &sRegionName,const std::string sArchitecture);
	 tBool bGetRegionNameByRegionCode(Json::Value &oRegionMapingArray,const tU8 u8RegionCode,std::string &sRegionName);
	 tBool bGetTcuType(const tU8 u8OEMName, const std::string sArchitecture,std::string &sTcuType);



};

#endif
